
//
//"Copyright (C) BenaTong 1991  All rights reserved"
//
// 12/31/91 discovered that SEC was defined as 100,000 not 1,000,000
//
#import <objc/Object.h>
#import <sgtty.h>

#define EVEN 	1
#define ODD  	2
#define NONE 	3
#define SPACE 	4
#define MARK 	5

#define SEC 1000000L
#define SERIALOK 0

#define PORTNOTOPEN 	-1
#define TIMEOUT 		-2
#define BADPARITY 		-3
#define BADBAUD 		-4
#define DEMO_EXPIRED	-999


@interface Serial:Object
{
	int ttyPtr;
	int baudrate;
	int par;
	id target;
	SEL theSelector;
	BOOL notifyStatus;
	char deviceName[20];
	BOOL reEnteredTtyHandler;
	unsigned long timeout;
}


+ initialize;
- init;
- (int) waitForInput;

- (int)setNotify:(SEL)aSelector with:anObject;
- setNotifyStatus:(BOOL)status;
- (BOOL) getNotifyStatus;

- (int) inputQueueSize;
- (int) outputQueueSize;

- (int) flushOutput;
- (int) flushInput;
- (int) flushAll;


- (int) openCBREAK: (char *) portStr Baudrate:(int) baud
					 Parity   :(int) parity;
					 
- (int) openRAW: (char *) portStr Baudrate:(int) baud;

- (BOOL) portIsOpen;					 
- (int)	closePort;

- (int) writeString:(char*)str;
- (int) readString: (char *) str forMaxOf:(int) max;
- (int) readString: (char *) str forMaxOf:(int) max term:(char) termChar;

- (int) writeBlock:(char*) buf for:(int)  num;
- (int) readBlock:(char*) buf for:(int) num;
- (int) readBlock:(char*) buf for:(int) num term:(char) termChar;

- (int) setBaudRate:(int) baud;
- (int) setParity:(int) parity;
-  (unsigned) setTimeout:(unsigned) time;

- (int) baudrate;
- (int) parity;
- (unsigned) timeout;
- (int) ttyptr;


- (char*) deviceName;

- (int) dropDTR;
- (int) raiseDTR;

- (int) break;
- (int) dropBREAK;
- (int) raiseBREAK;

- (int) useXONXOFF:(BOOL) status;
- (int) modifyCRLF:(BOOL) status;

-  target;
- (SEL) selector;

@end
